using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.Net;


namespace OpenAPI_App_Manager
{
    public partial class frmMain : Form
    {
        private AppSettings CurrentSettings;

        private List<frmMFPManagement> lWindows;

        private bool bStartup;

        private string AppVersion;

        frmPleaseWait winWait;
        //private Thread t;
        
        public frmMain()
        {
            bStartup = true;

            InitializeComponent();

            try
            {
                AppVersion = Application.ProductVersion;
                this.Text = Application.ProductName;// +" - version " + AppVersion;

                lWindows = new List<frmMFPManagement>();

                //Determine local IPv4 address
                IPHostEntry ipEntry = Dns.GetHostEntry(Dns.GetHostName());
                IPAddress ipThis = null;
                foreach (IPAddress ip in ipEntry.AddressList)
                {
                    if (ip.AddressFamily == System.Net.Sockets.AddressFamily.InterNetwork) //IPv4
                    {
                        ipThis = ip;
                        break;
                    }
                }

                //Load our settings
                CurrentSettings = Settings.GetAppSettings(AppDomain.CurrentDomain.BaseDirectory + "Settings.xml");

                if (CurrentSettings.Search.SNMPPingStartAddress == string.Empty && ipThis != null)
                    CurrentSettings.Search.SNMPPingStartAddress = ipThis.ToString().Substring(0, ipThis.ToString().LastIndexOf(".") + 1) + "1";
                if (CurrentSettings.Search.SNMPPingEndAddress == string.Empty && ipThis != null)
                    CurrentSettings.Search.SNMPPingEndAddress = ipThis.ToString().Substring(0, ipThis.ToString().LastIndexOf(".") + 1) + "254";

                mfpList.SearchSettings = CurrentSettings.Search;
                mfpList.AdvancedSearch = CurrentSettings.AdvancedSearch;

                foreach (MFPConfig mfp in CurrentSettings.MFPList)
                    mfpList.Add(mfp);

                bStartup = false;
            }
            catch (System.Configuration.ConfigurationErrorsException ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        private void SaveSettings()
        {
            if (!bStartup)
            {
                Settings.SaveAppSettings(CurrentSettings, AppDomain.CurrentDomain.BaseDirectory + "Settings.xml");
            }
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenAPI_App_Manager.frmAbout winAbout = new OpenAPI_App_Manager.frmAbout(Application.ProductName, AppVersion);
            winAbout.ShowDialog();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void settingsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenAPI_App_Manager.frmSearchSettings winSearchSettings = new OpenAPI_App_Manager.frmSearchSettings(CurrentSettings.Search);
            if (winSearchSettings.ShowDialog() == DialogResult.OK)
            {
                CurrentSettings.Search = winSearchSettings.Settings;
                mfpList.SearchSettings = winSearchSettings.Settings;
                SaveSettings();
            }
        }

        private void mfpList_ListChanged(object sender, EventArgs e)
        {
            CurrentSettings.MFPList = mfpList.MFPs;
            SaveSettings();
        }

        private void mfpList_MFPSelected(object sender, MFPConfig mfp)
        {
        }

        private void mfpList_OpenMFP(object sender, MFPConfig mfp)
        {
            mfpList.Visible = false;
            //frmMFPManagement.WaitDialogClosed += new frmMFPManagement.WaitDialogHandler(CloseWaitDialog);
            Thread t = new Thread(new ParameterizedThreadStart(WinWaitShow));
            t.Start(new int[] { this.Left + (this.Width / 2), this.Top + (this.Height / 2) });

            for (int i = 0; i < lWindows.Count; i++)
            {
                if (lWindows[i].MFP.Address == mfp.Address)
                {
                    if (lWindows[i].IsDisposed)
                    {
                        lWindows[i] = new frmMFPManagement(mfp, CurrentSettings);
                    }
                    if (!lWindows[i].Visible)
                    {
                        lWindows[i].Show();
                    }
                    
                    t.Abort();
                    
                    lWindows[i].BringToFront();
                    mfpList.Visible = true;
                    return;
                }
            }

            //Open a new frmMFPManagement, passing in the current mfp, allowing the user to manage it
            try
            {
                frmMFPManagement winMFP = new frmMFPManagement(mfp, CurrentSettings);
                if (winMFP.OpenAPIHandler.IsDeviceAlive() == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                {
                    lWindows.Add(winMFP);
                    lWindows[lWindows.Count - 1].Show();
                    t.Abort(); 

                }
                else
                {
                    t.Abort(); 
                    MessageBox.Show("Unable to communicate with MFP", "Communication error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                
            }
            catch (Exception) { }
            mfpList.Visible = true;
        }


        private void CloseWaitDialog()
        {
            //t.Abort();
        }

        private void mfpList_AdvancedSearchSettingsChanged(object sender, AdvancedSearchSettings Settings)
        {
            CurrentSettings.AdvancedSearch = Settings;
            SaveSettings();
        }


        private void WinWaitShow(object oPos)
        {
            int[] iPos = (int[])oPos;
            winWait = new frmPleaseWait();           
            //Enable the PleaseWait window
            winWait.SetDesktopLocation(iPos[0]-150, iPos[1]-100);
            winWait.ShowDialog();
        }
    }
}